/*
 * Copyright (c) 1999-2001 Lutris Technologies, Inc. All Rights
 * Reserved.
 * 
 * This source code file is distributed by Lutris Technologies, Inc. for
 * use only by licensed users of product(s) that include this source
 * file. Use of this source file or the software that uses it is covered
 * by the terms and conditions of the Lutris Enhydra Development License
 * Agreement included with this product.
 * 
 * This Software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF
 * ANY KIND, either express or implied. See the License for the specific terms
 * governing rights and limitations under the License.
 * 
 * Contributor(s):
 * 
 * $Id: TreeParser.java,v 1.1.1.1 2001/01/05 05:11:17 sese0235 Exp $
 */

package de.kxml.kdom;

import java.util.*;
import de.kxml.*;
import de.kxml.parser.*;

/**
 * a pull parser that re-parses a kdom tree.
 */
public class TreeParser extends Parser {

    /**
     * Class declaration
     *
     *
     * @author
     * @version %I%, %G%
     */
    class Position {
	Object   object;
	StartTag start;
	int      index = -1;
	Position previous;

	/**
	 * Constructor declaration
	 *
	 *
	 * @param element
	 * @param prev
	 *
	 * @see
	 */
	Position(Element element, Position prev) {
	    this.object = element;
	    previous = prev;
	    start = new StartTag(prev == null ? null : prev.start, 
				 element.getNamespace(), element.getName(), 
				 element.getAttributes(), 
				 element.getChildCount() == 0);

	    start.setPrefixMap(element.getPrefixMap());
	}

	/**
	 * Constructor declaration
	 *
	 *
	 * @param document
	 *
	 * @see
	 */
	Position(Document document) {
	    object = document;
	}

    }

    Position   current;
    ParseEvent next;

    /**
     * Constructor declaration
     *
     *
     * @param element
     *
     * @see
     */
    public TreeParser(Element element) {
	this(element, false);
    }

    /**
     * Constructor declaration
     *
     *
     * @param element
     * @param skipRoot
     *
     * @see
     */
    public TreeParser(Element element, boolean skipRoot) {
	current = new Position(element, null);

	if (skipRoot) {
	    current.index = 0;
	    current.start = null;
	} 

	read();
    }

    /**
     * Constructor declaration
     *
     *
     * @param document
     *
     * @see
     */
    public TreeParser(Document document) {
	current = new Position(document);

	read();
    }

    /**
     * Method declaration
     *
     *
     * @return
     *
     * @see
     */
    public ParseEvent peek() {
	return next;
    } 

    /**
     * Method declaration
     *
     *
     * @return
     *
     * @see
     */
    public ParseEvent read() {
	ParseEvent result = next;
	int	   i = current.index++;

	if (current.object instanceof Element) {
	    Element e = (Element) current.object;

	    if (i < 0) {
		next = current.start;
	    } else if (i >= e.getChildCount()) {
		if (current.start == null || i > e.getChildCount()) {
		    next = new EndDocument();
		} else {
		    next = new EndTag(current.start);

		    if (current.previous != null) {
			current = current.previous;
		    } 
		} 
	    } else {
		switch (e.getType(i)) {

		case Xml.TEXT:
		    next = new TextEvent(e.getText(i));

		    break;

		case Xml.ELEMENT:
		    current = new Position(e.getElement(i), current);

		    read();

		    break;

		default:
		    next = new LegacyEvent(e.getType(i), 
					   (String) e.getChild(i));
		}
	    } 
	} else {
	    throw new RuntimeException("document reparsing not yet implemented");
	}

	return result;
    } 

}

